define(['angular', 'app', 'NotificationsService', 'NotificationsInstanceBuilderService'], function (angular, app) {
	'use strict';

	app.controller('NotificationSettingsController', 
		function ($scope, $q, $timeout, $modalInstance, modalService, NotificationsPreferencesService, NotificationsInstanceBuilderService, NotificationsConstants, focusService) {

		(function init(){
			angular.extend($scope, NotificationsConstants['notification'].scope);
			
			$scope.preferences = {
				optInSelected: null,
				emailAddress: null,
				timeZone: null
			};

			NotificationsPreferencesService.getNotificationsPreference().then(function (response) {
				$scope.preferences.optInSelected = response.optInSelected ? "Yes" : "No";
			});

			NotificationsPreferencesService.getPreferencesData().then(function (response) {
				$scope.preferences.timeZone = response.timeZone;
				$scope.preferences.emailAddress = response.emailAddress;
				$scope.storedEmailAddress = response.emailAddress;
				$scope.isEmailAddressStored = !!response.emailAddress;
			});

			focusService.focusTopModal();
		})();


		var openWarningModal = function() {
			var modalContent = {
				closeButtonText: 'Cancel',
				actionButtonText: 'Save',
				headerText: 'Warning',
				bodyText: "<p>An email address is required to receive email notifications. If you do not provide an email address any future email notifications will be cancelled.</p>" +
					"<p>If you wish to continue saving, click SAVE, otherwise, select CANCEL to update your Notification Settings.</p>"
			};

			var options = {
				okButtonFirst: true
			};

			modalService.showModal({}, modalContent, options).then(function () {
				$scope.saveToBackend();
			}, function () {
				$timeout(focusService.focusTopModal);
				$scope.preferences.emailAddress = $scope.storedEmailAddress;
			});
		};

		$scope.save = function () {
			this.settingsForm.validationSummary.validate().then(function() {
				if ($scope.isEmailAddressStored && !$scope.preferences.emailAddress) {
					openWarningModal();
				} else {
					$scope.saveToBackend();
				}
			});
		};

		$scope.saveToBackend = function () {
			var promises = [];
			promises.push(NotificationsPreferencesService.updatePreferencesData($scope.preferences.emailAddress, $scope.preferences.timeZone));

			NotificationsPreferencesService.updateNotificationsPreference($scope.preferences.optInSelected === "Yes").then(function(){
				_.forOwn(NotificationsConstants, function (value, key) {
					if (NotificationsInstanceBuilderService.hasLiveInstance(key)) {
						var service = NotificationsInstanceBuilderService.instances[key];
						if(service.dataPointers.filters) {
							promises.push(service.fetch(service.dataPointers.filters));
						}
					}
				});

				$q.all(promises).then(function(){
					$modalInstance.close();
				});
			});
		};

        $scope.cancel = function() {
            $modalInstance.dismiss('cancel');
        };

        $scope.showUserGuide = function () {
            window.open("src/ui-components/modals/help/guide/guide.html#/features/notifications", "_blank", "location=no,scrollbars=1,resizable=1");
        };
	});
});